<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;

class CheckUserRights
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        $routeName = Route::currentRouteName();
        $userRights = Auth::user()->rights->menus->pluck('name')->toArray();

        $normalizedRouteName = str_replace(' ', '-', strtolower($routeName));

        $normalizedUserRights = array_map(function ($menu) {
            return str_replace(' ', '-', strtolower($menu));
        }, $userRights);

        if (!in_array($normalizedRouteName, $normalizedUserRights)) {
            return redirect()->back()->with('error', 'Access Denied!');
        }

        return $next($request);
    }
}
